// CANVAS
local PANEL = {};

// link to class
function PANEL:LinkToClass( cls )
	self.LinkedClass = cls;
	
end

// init
function PANEL:Init( )
	// linked calss
	self.LinkedClass = nil;

end

// register
vgui.Register( "ctl_canvas", PANEL, "Panel" );




// SCROLLING CANVAS
local PANEL = {};

// link to class
function PANEL:LinkToClass( cls )
	self.LinkedClass = cls;
	
end

// init
function PANEL:Init( )
	// linked calss
	self.LinkedClass = nil;
	
	// render frame
	self.RenderFrame = false;
	
	// our canvas
	self.Canvas = vgui.Create( "ctl_canvas", self );
	self.ScrollCanvas = vgui.Create( "ctl_canvas", self.Canvas );
	
	// vertical scroll
	self.VScroll = CtlScrollBar_class:create( self );
	self.VScroll:Hide()
	self.VScroll:SetPos( 0, 0 );
	self.VScroll:SetHorizontal( false );
	self.VScroll:AddEvent( "OnSliderMoved", "ScrollValueChanged", self );
	
	// horizontal scroll
	self.HScroll = CtlScrollBar_class:create( self );
	self.HScroll:Hide()
	self.HScroll:SetPos( 0, 0 );
	self.HScroll:SetHorizontal( true );
	self.HScroll:AddEvent( "OnSliderMoved", "ScrollValueChanged", self );
	
end


// perform layout
function PANEL:PerformLayout( )
	// sizes
	local x, y = self.ScrollCanvas:GetPos();
	local w, h = self.ScrollCanvas:GetSize();
	local pw, ph = self.Canvas:GetSize();
	
	// calc main control size.
	local width, height = self:GetSize();
	
	// vertical?
	if( self.VScroll && h > height ) then
		// make the bar visible.
		self.VScroll:Show();
		
		// setup bar range.
		self.VScroll:SetRange( 1, h, ph );
		
		// clamp value
		self.VScroll:SetValue( math.Clamp( self.VScroll:GetValue(), 1, h ) );
		
	elseif( self.VScroll ) then
		// hide.
		self.VScroll:Hide();
		
		// setpos.
		self.ScrollCanvas:SetPos( x, 0 );
		y = 0;
		
	end
	
	// horizontal?
	if( self.HScroll && w > width ) then
		// make the bar visible.
		self.HScroll:Show();
		
		// setup bar range.
		self.HScroll:SetRange( 1, w, pw );
		
		// clamp value
		self.HScroll:SetValue( math.Clamp( self.HScroll:GetValue(), 1, w ) );
		
	elseif( self.HScroll ) then
		// hide.
		self.HScroll:Hide();
		
		// setpos.
		self.ScrollCanvas:SetPos( 0, y );
		x = 0;
		
	end
	
	// only vertical
	if( self.VScroll:IsVisible() && !self.HScroll:IsVisible() ) then
		//
		self.VScroll:SetPos( width - 20, 0 );
		self.VScroll:SetSize( 18, height );
		
		// scale
		width = width - 20;
		
	// only horizontal
	elseif( !self.VScroll:IsVisible() && self.HScroll:IsVisible() ) then
		//
		self.HScroll:SetPos( 0, height - 20 );
		self.HScroll:SetSize( width, 18 );
		
		// scale
		height = height - 20;
		
	// both horizontal and vertical
	elseif( self.VScroll:IsVisible() && self.HScroll:IsVisible() ) then
		//
		self.VScroll:SetPos( width - 20, 0 );
		self.VScroll:SetSize( 18, height - 18 );
		
		self.HScroll:SetPos( 0, height - 20 );
		self.HScroll:SetSize( width - 18, 18 );
		
		// scale
		width = width - 20;
		height = height - 20;
		
	end

	// position canvas.
	self.Canvas:SetPos( 0, 0 );
	self.Canvas:SetSize( width, height );
	
	// resize.
	self:ScrollValueChanged();
	
	// bah.
	self.Canvas:InvalidateLayout();
	self.ScrollCanvas:InvalidateLayout();
	
end

// scrolled
function PANEL:OnMouseWheeled( delta )
	// capture!
	if( self.VScroll && self.VScroll:IsVisible() ) then
		// scale.
		self.VScroll:SetValue( self.VScroll:GetValue() - ( delta * 64 ) );
		
	end
	
end

// paint
function PANEL:Paint( )
	// don't render?
	if( !self.RenderFrame ) then return; end
	
	// frame.
	AppFramework:Theme():DrawFrame( 0, 0, self:GetWide(), self:GetTall(), FRAME_INSET );
	
	//
	return true;
	
end


// set render frame
function PANEL:SetRenderFrame( v )
	self.RenderFrame = v;

end


// do scroll
function PANEL:ScrollValueChanged( )
	// sizes
	local w, h = self.ScrollCanvas:GetSize();
	local pw, ph = self.Canvas:GetSize();
	local x = 0;
	local y = 0;
	
	// vertical
	if( self.VScroll && self.VScroll:IsVisible() ) then
		// calculate offset
		y = ( ( h - ph ) / h ) * self.VScroll:GetValue();
		
	end
	
	// horizontal
	if( self.HScroll && self.HScroll:IsVisible() ) then
		// calculate offset
		x = ( ( w - pw ) / w ) * self.HScroll:GetValue();
		
	end
	
	// set
	self.ScrollCanvas:SetPos( -x, -y );
	
end

// get canvas
function PANEL:GetCanvas( )
	return self.ScrollCanvas;
	
end

// register
vgui.Register( "ctl_scrollingcanvas", PANEL, "Panel" );



// create app framework control.
CtlScrollingCanvas_class 	= Control_class:create( nil, false, "ctl_scrollingcanvas" );

// set centered.
function CtlScrollingCanvas_class:GetCanvas( )
	return self:GetHandle():GetCanvas( );
	
end

// set centered.
function CtlScrollingCanvas_class:SetRenderFrame( v )
	self:GetHandle():SetRenderFrame( v );
	
end
